<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Answers\Schemas;

use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
class AnswerForm
{

 /**
     * Store custom components registered by the host app.
     */
    protected static array $extraComponents = [];

    /**
     * Allow the host app to register custom fields.
     */
    public static function appendComponents(array $components): void
    {
        static::$extraComponents = $components;
    }

    /**
     * Get the extra components for use in other forms (e.g., QuestionForm's Repeater).
     */
    public static function getExtraComponents(): array
    {
        return static::$extraComponents;
    }

    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('Extra Components')
                    ->collapsible()
                    ->visible(fn () => count(static::$extraComponents) > 0)
                    ->schema(static::$extraComponents),
            ]);
    }
}
