# Questionnaire Admin

[![Latest Version on Packagist](https://img.shields.io/packagist/v/concept7/questionnaire-admin.svg?style=flat-square)](https://packagist.org/packages/concept7/questionnaire-admin)
[![GitHub Tests Action Status](https://img.shields.io/github/actions/workflow/status/concept7/questionnaire-admin/run-tests.yml?branch=main&label=tests&style=flat-square)](https://github.com/concept7/questionnaire-admin/actions?query=workflow%3Arun-tests+branch%3Amain)
[![Total Downloads](https://img.shields.io/packagist/dt/concept7/questionnaire-admin.svg?style=flat-square)](https://packagist.org/packages/concept7/questionnaire-admin)

A standalone Filament panel for building and managing questionnaires. This package provides a user interface for the [concept7/laravel-questionnaire](https://github.com/concept7/laravel-questionnaire) package.

## Features

- **Questionnaire Management**: Create and manage multiple questionnaires.
- **Dynamic Questions**: Support for various question types.
- **Answer Tracking**: View and manage user responses.
- **Assessments**: Analyze and review questionnaire results.
- **Interactive Dashboards**: Visual charts for average scores and assessment details.
- **Filament Integration**: Built with Filament for a modern, responsive admin experience.

## Installation

You can install the package via composer. Since this package is hosted on a private Packagist repository, you must first add it to your `composer.json`:

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://packagist.concept7.nl"
    }
]
```

Then install the package:

```bash
composer require concept7/questionnaire-admin
```

You can run the install command with:

```bash
php artisan questionnaire-admin:install
```

This command will:

- Publish the configuration file.
- Publish the migrations.
- Optionally run the migrations.

## Usage

Register the plugin in your Filament Panel Provider (e.g., `AdminPanelProvider.php`):

```php
use Concept7\QuestionnaireAdmin\Filament\FilamentQuestionnaireAdminPlugin;

public function panel(Panel $panel): Panel
{
    return $panel
        ->plugins([
            FilamentQuestionnaireAdminPlugin::make(),
        ]);
}
```

The plugin will automatically register the following resources into your panel:

- **Questionnaires**: Define your forms and logic.
- **Questions**: Manage individual questions within questionnaires.
- **Answers**: Review submitted answers.
- **Assessments**: Detailed look at the outcomes of the questionnaires.

## Permissions

If you are using permissions within your Filament panel, ensure you add the necessary permissions and policies to your project. This package relies on standard Laravel policies for resource authorization.

## Configuration

The configuration file is published at `config/questionnaire-admin.php`. You can customize the behavior of the package using the following options:

```php
return [


    /*
    |--------------------------------------------------------------------------
    | Filament Panel Configuration
    |--------------------------------------------------------------------------
    |
    | This defines the path where the Filament admin resources will be registered.
    | Default: 'admin'
    |
    */
    'panel' => [
        'path' => 'admin',
    ],
];
```

### Options

- **`panel.path`**: The path segment within the Filament panel where resources are grouped or accessed.

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](.github/CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Jurn Spijksma](https://github.com/jurnspijksma)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
