<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages;

use Concept7\QuestionnaireAdmin\Filament\Resources\Categories\CategoryResource;
use Concept7\QuestionnaireAdmin\Filament\Widgets\QuestionnaireAverageScoresChart;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;
use Illuminate\Database\Eloquent\Model;

/**
 * @extends ViewRecord<Model>
 */
class ViewCategory extends ViewRecord
{
    protected static string $resource = CategoryResource::class;

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
        ];
    }

    protected function getFooterWidgets(): array
    {
        return [
            QuestionnaireAverageScoresChart::class,
        ];
    }

    public function getWidgetData(): array
    {
        return [
            'record' => $this->getRecord(),
        ];
    }
}
