<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Categories;

use BackedEnum;
use Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Schemas\CategoryForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\CreateCategory;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\EditCategory;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\ListCategories;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\ViewCategory;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Tables\CategoryTable;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class CategoryResource extends Resource
{
    protected static ?string $model = null;

    protected static string|UnitEnum|null $navigationGroup = null;

    protected static string|BackedEnum|null $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?int $navigationSort = 2;

    protected static bool $isScopedToTenant = false;

    public static function getModel(): string
    {
        return config('questionnaire.models.category');
    }

    public static function getNavigationGroup(): string
    {
        return __('questionnaire-admin::translations.questionnaires');
    }

    public static function getNavigationLabel(): string
    {
        return __('questionnaire-admin::translations.categories');
    }

    public static function getLabel(): string
    {
        return __('questionnaire-admin::translations.category');
    }

    public static function getPluralLabel(): string
    {
        return __('questionnaire-admin::translations.categories');
    }

    public static function form(Schema $schema): Schema
    {
        return CategoryForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return CategoryTable::configure($table);
    }

    public static function getPages(): array
    {
        return [
            'index' => ListCategories::route('/'),
            'create' => CreateCategory::route('/create'),
            'view' => ViewCategory::route('/{record}'),
            'edit' => EditCategory::route('/{record}/edit'),
        ];
    }
}
