<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Schemas;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class QuestionnaireForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Section::make()
                ->heading(__('Questionnaire view'))
                ->description(__('Here you can view the questionnaire and its questions.'))
                ->schema([
                    TextInput::make('title')
                        ->label('Title')
                        ->translateLabel()
                        ->required()
                        ->unique()
                        ->columnSpan(1),

                    Select::make('calculation_type')
                        ->label('Calculation Type')
                        ->translateLabel()
                        ->options(collect(CalculationTypeEnum::cases())->mapWithKeys(fn (CalculationTypeEnum $type) => [$type->value => $type->getLabel()]))
                        ->columnSpan(1),
                ])
                ->columnSpanFull()
                ->columns(2),
        ]);
    }
}
