<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires;

use BackedEnum;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\CreateQuestionnaire;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\EditQuestionnaire;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\ListQuestionnaires;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Pages\ViewQuestionnaire;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\RelationManagers\AssessmentRelationManager;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\RelationManagers\QuestionsRelationManager;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Schemas\QuestionnaireForm;
use Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Tables\QuestionnairesTable;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class QuestionnaireResource extends Resource
{
    protected static ?string $model = null;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'title';

    public static function getModel(): string
    {
        return config('questionnaire.models.questionnaire');
    }

    public static function form(Schema $schema): Schema
    {
        return QuestionnaireForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return QuestionnairesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            QuestionsRelationManager::class,
            AssessmentRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListQuestionnaires::route('/'),
            'create' => CreateQuestionnaire::route('/create'),
            'view' => ViewQuestionnaire::route('/{record}'),
            'edit' => EditQuestionnaire::route('/{record}/edit'),
        ];
    }
}
