<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Schemas;

use Concept7\QuestionnaireAdmin\Filament\Widgets\AssessmentDetailChart;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\HtmlString;

class AssessmentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make(__('Assessment Visualisation'))
                    ->schema([
                        Placeholder::make('chart')
                            ->hiddenLabel()
                            ->translateLabel()
                            ->content(function ($record) {
                                if (! $record) {
                                    return null;
                                }

                                $widgetClass = AssessmentDetailChart::class;
                                if (! class_exists($widgetClass)) {
                                    return null;
                                }

                                return new HtmlString(Blade::render(
                                    '@livewire($component, ["record" => $record])',
                                    ['component' => $widgetClass, 'record' => $record]
                                ));
                            })
                            ->columnSpanFull(),
                    ])
                    ->collapsible(),

                Section::make(__('Assessment Details'))
                    ->schema([
                        Placeholder::make('participant_display')
                            ->label(__('Participant'))
                            ->content(fn ($record) => $record->assessmentable?->name ?? 'Guest'),

                        DateTimePicker::make('created_at')
                            ->label('Completed At')
                            ->translateLabel()
                            ->disabled(),
                    ])
                    ->columns(2),

                Section::make(__('Results'))
                    ->schema([
                        Repeater::make('answers')
                            ->label('Given Answers')
                            ->translateLabel()
                            ->relationship('answers')
                            ->schema([
                                Grid::make(3)->schema([
                                    TextInput::make('assessment_id')
                                        ->label('Assessment ID')
                                        ->translateLabel()
                                        ->columnSpan(1)
                                        ->disabled(),

                                    TextInput::make('answer')
                                        ->label('Answer')
                                        ->translateLabel()
                                        ->columnSpan(1)
                                        ->dehydrated(false)
                                        ->formatStateUsing(function ($record) {
                                            $record->load('answer');

                                            return $record->answer?->text ?? '-';
                                        })
                                        ->disabled(),

                                    TextInput::make('score')
                                        ->label('Score')
                                        ->translateLabel()
                                        ->numeric()
                                        ->columnSpan(1)
                                        ->dehydrated(false)
                                        ->formatStateUsing(function ($record) {
                                            $record->load('answer');

                                            return $record->answer?->score ?? 0;
                                        })
                                        ->disabled(),
                                ]),
                            ])
                            ->columnSpanFull(),
                    ])
                    ->collapsible(),
            ]);
    }
}
