<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Interpretations\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class InterpretationForm
{
    public static function configure(Schema $schema): Schema
    {
        $categoryClass = config('questionnaire.models.category');
        $scaleClass = config('questionnaire.models.scale');

        return $schema
            ->schema([
                Section::make()
                    ->heading(trans('questionnaire-admin::translations.interpretation_details'))
                    ->description(trans('questionnaire-admin::translations.provide_the_details_for_this_interpretation'))
                    ->schema([
                        TextInput::make('min_score')
                            ->label(trans('questionnaire-admin::translations.min_score')),

                        TextInput::make('max_score')
                            ->label(trans('questionnaire-admin::translations.max_score')),

                        Select::make('category_id')
                            ->label(trans('questionnaire-admin::translations.category'))
                            ->options($categoryClass::all()->pluck('name', 'id')),

                        Select::make('scale_id')
                            ->label(trans('questionnaire-admin::translations.scale'))
                            ->options($scaleClass::all()->pluck('name', 'id')),
                    ]),
            ]);
    }
}
