<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Assessments\Tables;

use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class AssesmentTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->label(__('questionnaire-admin::translations.id'))
                    ->sortable(),

                TextColumn::make('assessmentable.name')
                    ->label(__('questionnaire-admin::translations.participant'))
                    ->searchable()
                    ->placeholder(__('questionnaire-admin::translations.guest')),

                TextColumn::make('created_at')
                    ->label(__('questionnaire-admin::translations.date'))
                    ->dateTime()
                    ->sortable(),
            ])
            ->actions([
                ViewAction::make(),
            ]);
    }
}
