<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questions\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class QuestionsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('text')
                    ->label('Text')
                    ->translateLabel()
                    ->formatStateUsing(fn ($state) => str($state)->limit(50)),

                TextColumn::make('type')
                    ->label('Type')
                    ->translateLabel(),

                TextColumn::make('weight')
                    ->label('Weight')
                    ->translateLabel(),

                TextColumn::make('category.name')
                    ->label('Category')
                    ->translateLabel(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
