<?php

namespace Concept7\QuestionnaireAdmin;

use Concept7\QuestionnaireAdmin\Filament\Widgets\AssessmentDetailChart;
use Concept7\QuestionnaireAdmin\Filament\Widgets\QuestionnaireAverageScoresChart;
use Livewire\Livewire;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class QuestionnaireAdminServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package->name('questionnaire-admin')
            ->hasConfigFile()
            ->hasTranslations()
            ->discoversMigrations()
            ->runsMigrations()
            ->hasInstallCommand(function (InstallCommand $command) {
                $command
                    ->publishConfigFile()
                    ->publishMigrations()
                    ->askToRunMigrations()
                    ->askToStarRepoOnGitHub('concept7/questionnaire-admin');
            });
    }

    public function packageBooted()
    {
        Livewire::component('questionnaire-average-scores-chart', QuestionnaireAverageScoresChart::class);

        Livewire::component('assessment-detail-chart', AssessmentDetailChart::class);
    }
}
