<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Questionnaires\Schemas;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class QuestionnaireForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Section::make()
                ->heading(__('questionnaire-admin::translations.questionnaire_details'))
                ->description(__('questionnaire-admin::translations.questionnaire_description'))
                ->schema([
                    TextInput::make('title')
                        ->label(__('questionnaire-admin::translations.title'))
                        ->required()
                        ->unique()
                        ->columnSpan(1),

                    Select::make('calculation_type')
                        ->label(__('questionnaire-admin::translations.calculation_type'))
                        ->options(collect(CalculationTypeEnum::cases())->mapWithKeys(fn (CalculationTypeEnum $type) => [$type->value => $type->getLabel()]))
                        ->columnSpan(1),
                ])
                ->columnSpanFull()
                ->columns(2),
        ]);
    }
}
