<?php

namespace Concept7\QuestionnaireAdmin\Filament\Resources\Categories\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class CategoryTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label(trans('questionnaire-admin::translations.name'))
                    ->limit(50)
                    ->wrap()
                    ->searchable(),
                TextColumn::make('description')
                    ->label(trans('questionnaire-admin::translations.description'))
                    ->limit(50)
                    ->wrap()
                    ->searchable(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([DeleteBulkAction::make()]),
            ]);
    }
}
