<?php

use Concept7\LaravelQuestionnaire\Actions\Assessments\CreateAssessment;
use Concept7\LaravelQuestionnaire\Models\Assessment;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\User;
use Illuminate\Support\Collection;

beforeEach(function () {
    config()->set('questionnaire.models.participant', User::class);
});

it('creates an "linked" assessment and adds it to the payload', function () {
    config()->set('questionnaire.models.user', User::class);
    $participant = User::factory()->create();

    $questionnaire = Questionnaire::factory()->create();

    $payload = collect([
        'participant' => $participant,
        'questionnaire' => $questionnaire,
    ]);

    $pipe = new CreateAssessment;

    $next = function (Collection $payload) {
        return $payload;
    };

    $resultPayload = $pipe->handle($payload, $next);

    $this->assertDatabaseHas('assessments', [
        'assessmentable_type' => $participant->getMorphClass(),
        'assessmentable_id' => $participant->getKey(),
        'questionnaire_id' => $questionnaire->getKey(),
    ]);

    expect($resultPayload->has('assessment'))->toBeTrue();

    $this->assertInstanceOf(Assessment::class, $resultPayload->get('assessment'));

    $this->assertEquals(
        $participant->id,
        $resultPayload->get('assessment')->assessmentable_id
    );
});

it('throws an error if the questionnaire is missing from the payload', function () {
    $participant = User::factory()->create();
    $payload = collect(['participant' => $participant]);
    $pipe = new CreateAssessment;
    $next = fn ($p) => $p;

    $pipe->handle($payload, $next);
})->throws(\Exception::class, 'Questionnaire not found');
