<?php

namespace Concept7\LaravelQuestionnaire\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;

/**
 * Trait AssessmentableTrait
 *
 * @mixin \Illuminate\Database\Eloquent\Model
 */
trait AssessmentableTrait
{
    public function assessments(): MorphMany
    {
        $assessmentClass = config('questionnaire.models.assessment');

        return $this->morphMany($assessmentClass, 'assessmentable');
    }
}
