<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\CategoryFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    /** @use HasFactory<CategoryFactory> */
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
    ];

    public function questions(): HasMany
    {
        $questionModel = config('questionnaire.models.question');

        return $this->hasMany($questionModel);
    }

    public function scale(): BelongsTo
    {
        $scaleModel = config('questionnaire.models.scale');

        return $this->belongsTo($scaleModel);
    }

    public function interpretation(): HasMany
    {
        $interpretationModel = config('questionnaire.models.interpretation');

        return $this->hasMany($interpretationModel);
    }
}
