<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Answer;
use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\Scale;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;

class MvoScanSeederAction
{
    public function run($name)
    {
        $jsonPath = __DIR__.'/../../../database/seeders/data/mvo-scan.json';
        $data = json_decode(File::get($jsonPath), true);

        $questionnaireData = $data['questions'];
        $categoryResultsData = $data['results'];

        $questionnaire = Questionnaire::create([
            'title' => $name,
            'slug' => str($name)->slug()->toString(),
            'calculation_type' => CalculationTypeEnum::WEIGHTED_AVERAGE,
        ]);

        $sliderAnswersTemplate = [];
        for ($i = 0; $i <= 10; $i++) {
            $sliderAnswersTemplate[] = [
                'text' => (string) $i,
                'score' => $i,
                'order' => $i,
            ];
        }

        $scoreMap = [
            'result_a' => ['min' => 0, 'max' => 30],
            'result_b' => ['min' => 40, 'max' => 59],
            'result_c' => ['min' => 60, 'max' => 79],
            'result_d' => ['min' => 80, 'max' => 99],
            'result_e' => ['min' => 100, 'max' => 100],
        ];

        $categoriesCache = [];

        foreach ($categoryResultsData as $categorySlug => $catData) {
            $categoryModel = Category::firstOrCreate(
                ['name' => $catData['term_name']],
                ['description' => $catData['card_text']],
            );
            $categoriesCache[$categorySlug] = $categoryModel;

            foreach ($scoreMap as $resultKey => $range) {
                $resultData = $catData[$resultKey] ?? null;
                if (empty($resultData) || empty($resultData['content'])) {
                    continue;
                }

                $scaleName =
                    $catData['term_name'].
                    ' - Resultaat '.
                    strtoupper(str_replace('result_', '', $resultKey));

                $scaleModel = Scale::create([
                    'name' => $scaleName,
                    'description' => $resultData['content'],
                ]);

                Interpretation::create([
                    'category_id' => $categoryModel->getKey(),
                    'scale_id' => $scaleModel->getKey(),
                    'min_score' => $range['min'],
                    'max_score' => $range['max'],
                ]);
            }
        }

        foreach ($questionnaireData as $index => $data) {
            $categorySlug = $data['category'][0];

            if (! isset($categoriesCache[$categorySlug])) {
                Log::warning(
                    "Seeder: Categorie '$categorySlug' niet gevonden voor vraag: '{$data['title']}'",
                );

                continue;
            }
            $category = $categoriesCache[$categorySlug];

            $question = Question::create([
                'questionnaire_id' => $questionnaire->getKey(),
                'text' => $data['title'],
                'category_id' => $category->getKey(),
                'type' => InputTypeEnum::SLIDER,
                'weight' => 5, // every question in mvo has a weight of 5
            ]);

            foreach ($sliderAnswersTemplate as $answerData) {
                Answer::create([
                    'question_id' => $question->getKey(),
                    'text' => $answerData['text'],
                    'score' => $answerData['score'],
                    'order' => $answerData['order'],
                ]);
            }
        }
    }
}
