@props(['question', 'fieldName', 'oldValue'])

@foreach($question->answers as $answer)
    @php
        // The ID must be unique for each radio button
        $fieldId = 'answer_' . $answer->getKey();
    @endphp
    <div class="relative flex items-center">
        <x-laravel-questionnaire::radio
            id="{{ $fieldId }}"
            name="{{ $fieldName }}"
            value="{{ $answer->getKey() }}"
            :checked="$oldValue == $answer->getKey()"
        ></x-laravel-questionnaire::radio>

        <label for="{{ $fieldId }}" class="ml-2 text-sm font-medium text-gray-900">
            {{ $answer->text }}
        </label>
    </div>
@endforeach
