<?php

namespace Concept7\LaravelQuestionnaire\Support;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Session;

class QuestionnaireContext
{
    const KEY = 'questionnaire_participant_context';

    /**
     * Host calls this to register the participant.
     */
    public static function set(Model $participant): void
    {
        Session::put(self::KEY, [
            'type' => $participant->getMorphClass(),
            'id' => $participant->getKey(),
        ]);
    }

    /**
     * Package calls this to get the participant.
     */
    public static function get(): ?array
    {
        return Session::get(self::KEY);
    }

    /**
     * Package calls this after saving.
     */
    public static function clear(): void
    {
        Session::forget(self::KEY);
    }
}
