<?php

namespace Concept7\LaravelQuestionnaire\Database\Factories;

use Concept7\LaravelQuestionnaire\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Category>
 */
class CategoryFactory extends Factory
{
    public function modelName(): string
    {
        return config('questionnaire.models.category');
    }

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->sentence(),
            'description' => fake()->sentence(),
        ];
    }
}
