<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;

class CreateAssessment
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return void
     */
    public function handle(Collection $payload, Closure $next)
    {
        $questionnaire = $payload->get('questionnaire');
        $participant = $payload->get('participant');
        $assessmentClass = config('questionnaire.models.assessment');

        if (! $questionnaire) {
            throw new \Exception('Questionnaire not found');
        }

        if ($participant) {
            $assessment = $participant->assessments()->create([
                'questionnaire_id' => $questionnaire->getKey(),
                'completed_at' => now(),
            ]);
        } else {
            $assessment = $assessmentClass::create([
                'questionnaire_id' => $questionnaire->getKey(),
                'completed_at' => now(),
            ]);
        }

        $payload->put('assessment', $assessment);

        return $next($payload);
    }
}
