<?php

use Concept7\LaravelQuestionnaire\Http\Controllers\Questionnaire\AssessmentController;
use Illuminate\Support\Facades\Route;

Route::middleware(['web'])->group(function () {
    Route::get('/questionnaire/{questionnaire:slug}/thank-you', [AssessmentController::class, 'thankYou'])
        ->name('questionnaire.thankyou');

    Route::middleware(config('questionnaire.middleware.assessments.create', []))->group(function () {
        Route::resource('questionnaire.assessments', AssessmentController::class)
            ->scoped(['questionnaire' => 'slug'])
            ->except('show');
    });

    Route::middleware(config('questionnaire.middleware.assessment.show', []))->group(function () {
        Route::get('/questionnaire/{questionnaire:slug}/assessments/{assessment}', [
            AssessmentController::class,
            'show',
        ])->name('questionnaire.assessments.show');
    });
});
