<?php

namespace Concept7\LaravelQuestionnaire\Strategies;

use Concept7\LaravelQuestionnaire\Contracts\ScoreCalculationStrategy;
use Illuminate\Support\Collection;

class HighestScoreStrategy implements ScoreCalculationStrategy
{
    public function calculate(Collection $answers): float|int
    {
        // Returns the maximum value of the 'score' key
        return $answers->max('score') ?? 0;
    }
}
