<?php

namespace Concept7\LaravelQuestionnaire\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class QuestionnaireInvitation extends Notification
{
    public function __construct(
        public $questionnaire,
        public string $signedUrl
    ) {}

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Invitation to take the questionnaire')
            ->line('You have been invited to take the questionnaire: '.$this->questionnaire->title)
            ->action('Take the questionnaire', $this->signedUrl);
    }
}
