<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('interpretations', function (Blueprint $table) {
            $table->id();

            $table->unsignedInteger('min_score')->default(0);
            $table->unsignedInteger('max_score')->default(5);

            $table->foreignId('category_id')
                ->constrained('categories')
                ->cascadeOnDelete();

            $table->foreignId('scale_id')
                ->constrained('scales')
                ->cascadeOnDelete();

            $table->timestamps();
        });

        Schema::create('assessment_results', function (Blueprint $table) {
            $table->id();

            $table->integer('total_score')->default(0);

            $table->foreignId('assessment_id')
                ->constrained('assessments')
                ->cascadeOnDelete();

            $table->foreignId('category_id')
                ->constrained('categories')
                ->cascadeOnDelete();

            $table->foreignId('scale_id')
                ->constrained('scales')
                ->cascadeOnDelete();

            $table->timestamps();
        });

    }

    public function down(): void
    {
        Schema::dropIfExists('interpretations');
        Schema::dropIfExists('assessment_results');
    }
};
