<?php

use Illuminate\Foundation\Http\Middleware\HandlePrecognitiveRequests;
use Illuminate\Routing\Router;

it('applies HandlePrecognitiveRequests middleware when questionnaire.mode contains "alpine"', function () {
    // Set config to a mode that contains 'alpine'
    config()->set('questionnaire.mode', 'alpine');

    // Get the router instance
    $router = app(Router::class);

    // Re-boot the service provider to apply the middleware
    $provider = new \Concept7\LaravelQuestionnaire\LaravelQuestionnaireServiceProvider(app());
    $provider->bootingPackage();

    // Get the middleware stack for the 'web' group
    $webMiddleware = $router->getMiddlewareGroups()['web'] ?? [];

    // Assert that HandlePrecognitiveRequests is in the middleware stack
    expect($webMiddleware)->toContain(HandlePrecognitiveRequests::class);
});

it('applies HandlePrecognitiveRequests middleware when questionnaire.mode is "alpine_via_api"', function () {
    // Set config to alpine_via_api which also contains 'alpine'
    config()->set('questionnaire.mode', 'alpine_via_api');

    // Get the router instance
    $router = app(Router::class);

    // Re-boot the service provider to apply the middleware
    $provider = new \Concept7\LaravelQuestionnaire\LaravelQuestionnaireServiceProvider(app());
    $provider->bootingPackage();

    // Get the middleware stack for the 'web' group
    $webMiddleware = $router->getMiddlewareGroups()['web'] ?? [];

    // Assert that HandlePrecognitiveRequests is in the middleware stack
    expect($webMiddleware)->toContain(HandlePrecognitiveRequests::class);
});

it('does not apply HandlePrecognitiveRequests middleware when questionnaire.mode does not contain "alpine"', function () {
    // Set config to a mode that does NOT contain 'alpine'
    config()->set('questionnaire.mode', 'default');

    // Create a fresh router instance to ensure clean state
    $router = app(Router::class);

    // Get the initial middleware count
    $initialWebMiddleware = $router->getMiddlewareGroups()['web'] ?? [];
    $initialCount = count(array_filter($initialWebMiddleware, fn($m) => $m === HandlePrecognitiveRequests::class));

    // Re-boot the service provider
    $provider = new \Concept7\LaravelQuestionnaire\LaravelQuestionnaireServiceProvider(app());
    $provider->bootingPackage();

    // Get the middleware stack for the 'web' group after booting
    $finalWebMiddleware = $router->getMiddlewareGroups()['web'] ?? [];
    $finalCount = count(array_filter($finalWebMiddleware, fn($m) => $m === HandlePrecognitiveRequests::class));

    // Assert that the middleware was not added (count should remain the same)
    expect($finalCount)->toBe($initialCount);
});
