<?php

use Concept7\LaravelQuestionnaire\Actions\Assessments\CreateAssessment;
use Concept7\LaravelQuestionnaire\Models\Assessment;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\User;
use Illuminate\Support\Collection;

beforeEach(function(){
    config()->set('questionnaire.models.user', User::class);
});
it('creates an assessment and adds it to the payload',function(){

    $user = User::factory()->create();

    $questionnaire = Questionnaire::factory()->create();

    $payload = collect([
        'user' => $user,
        'questionnaire' => $questionnaire,
    ]);

    $pipe = new CreateAssessment();

    $next = function( Collection $payload ){
      return $payload;
    };

    $resultPayload = $pipe->handle($payload, $next);

    $this->assertDatabaseHas('assessments', [
        'user_id' => $user->getKey(),
        'questionnaire_id' => $questionnaire->getKey(),
    ]);
    expect($resultPayload->has('assessment'))->toBeTrue();
    $this->assertInstanceOf(Assessment::class, $resultPayload->get('assessment'));
    $this->assertEquals($user->id, $resultPayload->get('assessment')->user_id);
});

it('throws an error if the user is missing from the payload',function(){
    $questionnaire = Questionnaire::factory()->create();
    $payload = collect(['questionnaire' => $questionnaire]);
    $pipe = new CreateAssessment();
    $next = fn($p) => $p;

    $pipe->handle($payload, $next);
})->throws(\Exception::class, 'User or Questionnaire not found');

it('throws an error if the questionnaire is missing from the payload',function(){
    $user = User::factory()->create();
    $payload = collect(['user' => $user]);
    $pipe = new CreateAssessment();
    $next = fn($p) => $p;

    $pipe->handle($payload, $next);
})->throws(\Exception::class, 'User or Questionnaire not found');
