<?php

namespace Concept7\LaravelQuestionnaire\Tests;

use Illuminate\Support\Facades\Storage;

use Concept7\LaravelQuestionnaire\LaravelQuestionnaireServiceProvider;
use Illuminate\Database\Eloquent\Factories\Factory;

use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{

    protected function setUp(): void
    {
        parent::setUp();

        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

        Factory::guessFactoryNamesUsing(
            fn (string $modelName) => 'Concept7\\LaravelQuestionnaire\\Database\\Factories\\'.class_basename($modelName).'Factory'
        );
    }
    /**
     * @param  \Illuminate\Foundation\Application  $app
     */
    protected function getPackageProviders($app): array
    {
        return [
            LaravelQuestionnaireServiceProvider::class,
        ];
    }

    protected function getEnvironmentSetUp($app)
    {
        config()->set('database.default', 'testing');
        config()->set('database.connections.testing', [
            'driver' => 'sqlite',
            'database' => ':memory:', // In-memory database
            'prefix' => '',
        ]);

        config()->set('mail.driver', 'log');

        Storage::fake('local');
        Storage::fake('secondLocal');
    }
}
