<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Questionnaire extends Model
{
    /** @use HasFactory<\Database\Factories\QuestionnaireFactory> */
    use HasFactory;

    protected $fillable = [
        "title",
        "slug",
        "calculation_type",
        "result_template",
    ];

    protected $casts = [
        "calculation_type" => CalculationTypeEnum::class,
    ];

    protected function slug(): Attribute
    {
        return Attribute::make(get: fn(string $value) => $value);
    }
    /**
     * @return HasMany<Model,Questionnaire>
     */
    public function assessments(): HasMany
    {
        $assessmentModel = config("questionnaire.models.assessment");

        return $this->hasMany($assessmentModel);
    }

    /**
     * @return HasMany<Model,Questionnaire>
     */
    public function questions(): HasMany
    {
        $questionModel = config("questionnaire.models.question");

        return $this->hasMany($questionModel);
    }
}
