<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\QuestionFactory;
use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Answer;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Question extends Model implements Sortable
{
    /** @use HasFactory<QuestionFactory> */
    use HasFactory;
    use SortableTrait;

    protected $casts = [
        'type' => InputTypeEnum::class
    ];

    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];

    protected $fillable = [
        'text',
        'order',
        'category_id',
        'questionnaire_id',
        'type',
        'weight'
    ];

    public function questionnaire(): BelongsTo
    {
        $questionnaireModel = config('questionnaire.models.questionnaire');

        return $this->belongsTo($questionnaireModel);
    }

    public function category(): BelongsTo
    {
       $categoryModel = config('questionnaire.models.category');

        return $this->BelongsTo($categoryModel);
    }

    public function answers(): HasMany
    {
        $answerModel = config('questionnaire.models.answer');

        return $this->hasMany($answerModel);
    }

    protected function sliderMin(): Attribute
    {
        return Attribute::make(
            get: fn() => $this->category->interpretation?->min_score ?? 0,
        );
    }

    protected function sliderMax(): Attribute
    {
        return Attribute::make(
            get: fn() => $this->category->interpretation?->max_score ?? 10,
        );
    }

    /**
     * Gets the slider's LEFT label from the parent scale.
     */
    protected function sliderLabelMin(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->interpretation?->scale?->name ?? 'Min',
        );
    }

    /**
     * Gets the slider's RIGHT label from the parent scale.
     */
    protected function sliderLabelMax(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->interpretation?->scale?->name ?? 'Max',
        );
    }
}
