<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class Interpretation extends Model
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    protected $fillable = [
        'category_id',
        'scale_id',
        'min_score',
        'max_score',
    ];

    public function scale(): BelongsTo
    {
        $scaleModel = config('questionnaire.models.scale');

        return $this->BelongsTo($scaleModel);
    }

    public function category(): BelongsTo
    {
        $categoryModel = config('questionnaire.models.category');

        return $this->BelongsTo($categoryModel);
    }
}
