<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Testing\Fluent\Concerns\Has;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class AssessmentResult extends Model
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    protected $fillable = [
        'assessment_id',
        'category_id',
        'total_score',
        'scale_id',
        'created_at',
        'updated_at',
    ];

    public function category(): BelongsTo
    {
        $categoryModel = config('questionnaire.models.category');

        return $this->belongsTo($categoryModel);
    }

    public function assessment(): BelongsTo
    {
        $assessmentModel = config('questionnaire.models.assessment');

        return $this->belongsTo($assessmentModel);
    }

    public function scale(): BelongsTo
    {
        $scaleModel = config('questionnaire.models.scale');

        return $this->belongsTo($scaleModel);
    }

    protected function formattedPercentage(): Attribute
    {
        return Attribute::make(
            get: function () {
                return match($this->assessment->questionnaire->calculation_type) {
                    default => $this->totalScore . '%',
                };
            }
        );
    }

    public function calculatePercentage($totalScore)
    {
        return round(($totalScore / $this->scale()->max_score) * 100) .'%';
    }
}
