<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Testing\Fluent\Concerns\Has;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class AssessmentAnswer extends Model
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;

    protected $fillable = [
        'assessment_id',
        'answer_id',
    ];

    public function answer(): BelongsTo
    {
        $answerModel = config('questionnaire.models.answer');

        return $this->belongsTo($answerModel);
    }

    public function assessment(): BelongsTo
    {
        $assessmentModel = config('questionnaire.models.assessment');

        return $this->belongsTo($assessmentModel);
    }
}
