<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Testing\Fluent\Concerns\Has;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Assessment extends Model
{
    /** @use HasFactory<\Concept7\LaravelQuestionnaire\Database\Factories\AssessmentFactory> */
    use HasFactory;

    protected $fillable = [
        'user_id',
        'questionnaire_id',
        'completed_at'
    ];

    public function user(): BelongsTo
    {
        $userModel = config('questionnaire.models.user');

        return $this->belongsTo($userModel);
    }

    public function questionnaire(): BelongsTo
    {
        $questionnaireModel = config('questionnaire.models.questionnaire');

        return $this->belongsTo($questionnaireModel);
    }

    public function answers(): HasMany
    {
        $answerModel = config('questionnaire.models.answer');

        return $this->hasMany($answerModel);
    }

    public function results(): HasMany
    {
        $resultModel = config('questionnaire.models.assessment_result');
        return $this->hasMany($resultModel);
    }

}
