<?php

namespace Concept7\LaravelQuestionnaire\Models;

use Concept7\LaravelQuestionnaire\Database\Factories\AnswerFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Testing\Fluent\Concerns\Has;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Answer extends Model implements Sortable
{
    /** @use HasFactory<AnswerFactory> */
    use HasFactory;
    use SortableTrait;

    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];

    protected $fillable = [
        'text',
        'score',
        'order',
        'question_id',
    ];

    public function question(): BelongsTo
    {
        $questionModel = config('questionnaire.models.question');

        return $this->belongsTo($questionModel);
    }
}
