<?php

namespace Concept7\LaravelQuestionnaire\Http\Requests;

use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreAssessmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $questionnaire = $this->route('questionnaire');
        $questionnaire->load([
            'questions.answers',
        ]);

        $rules = [];

        foreach ($questionnaire->questions as $question) {
            $key = 'questions_' . $question->id;
            $validOptionIds = $question->answers->pluck('id')->all();

            switch ($question->type) {
                case InputTypeEnum::RADIO:
                case InputTypeEnum::SELECT:
                case InputTypeEnum::SLIDER:
                    $rules[$key] = [
                        'required',
                        'integer',
                        Rule::in($validOptionIds),
                    ];
                    break;

                case InputTypeEnum::CHECKBOX:
                    $rules[$key] = ['required', 'array'];
                    $rules[$key . '.*'] = [
                        'required',
                        'integer',
                        Rule::in($validOptionIds),
                    ];
                    break;
            }
        }

        return $rules;
    }
}
