<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders;

use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Answer;
use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\Scale;
use Illuminate\Support\Facades\File;

class MinimalFakedSeederAction
{
    public function run($name)
    {
        $jsonPath = __DIR__ . "/../../../database/seeders/data/minimal.json";
        $data = json_decode(File::get($jsonPath), true);

        $questionnaire = Questionnaire::create([
            "title" => $name,
            "slug" => str($name)->slug()->toString(),
        ]);

        $scales = [];
        foreach ($data["scales"] as $key => $scaleName) {
            $scales[$key] = Scale::create(["name" => $scaleName])->getKey();
        }

        $categories = [];
        foreach ($data["categories"] as $categoryName) {
            $categories[$categoryName] = Category::create([
                "name" => $categoryName,
            ]);
        }

        foreach ($data["interpretations"] as $inter) {
            Interpretation::create([
                "category_id" => $categories[$inter["category"]]->getKey(),
                "scale_id" => $scales[(string) $inter["scale_key"]],
                "min_score" => $inter["min"],
                "max_score" => $inter["max"],
            ]);
        }

        foreach ($data["questions"] as $index => $qData) {
            $question = Question::create([
                "questionnaire_id" => $questionnaire->getKey(),
                "text" => $qData["question"],
                "category_id" => $categories[$qData["category"]]->getKey(),
                "type" => $qData["type"] ?? InputTypeEnum::RADIO,
                "order" => $index + 1,
            ]);

            foreach ($qData["answers"] as $order => $answerData) {
                Answer::create([
                    "text" => $answerData["text"],
                    "question_id" => $question->getKey(),
                    "score" => $answerData["score"],
                    "order" => $order + 1,
                ]);
            }
        }
    }
}
