<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders;

use Concept7\LaravelQuestionnaire\Models\Answer;
use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\Scale;
use Illuminate\Support\Facades\File;

class FourDklSeederAction
{
    public function run($name)
    {
        $jsonPath = __DIR__ . "/../../../database/seeders/data/4dkl.json";
        $data = json_decode(File::get($jsonPath), true);

        $questionnaire = Questionnaire::create([
            "title" => $name,
            "slug" => str($name)->slug()->toString(),
        ]);

        $scales = [];
        foreach ($data["scales"] as $key => $scaleName) {
            $scales[$key] = Scale::create(["name" => $scaleName])->getKey();
        }

        $categories = [];
        foreach ($data["categories"] as $key => $categoryName) {
            $categories[$key] = Category::create([
                "name" => $categoryName,
            ])->getKey();
        }

        foreach ($data["interpretations"] as $inter) {
            Interpretation::create([
                "category_id" => $categories[$inter["category"]],
                "scale_id" => $scales[$inter["scale"]],
                "min_score" => $inter["min"],
                "max_score" => $inter["max"],
            ]);
        }

        // 5. Define the Answer options and their scores
        $answersTemplate = $data["answersTemplate"];
        $prefixes = $data["prefixes"];

        // 8. Loop and create the Questions and their corresponding Answers
        foreach ($data["questions"] as $qData) {
            $text =
                $qData["key"] === "full"
                    ? $qData["text"]
                    : $prefixes[$qData["key"]] . $qData["text"];

            $question = Question::create([
                "questionnaire_id" => $questionnaire->getKey(),
                "text" => $text,
                "category_id" => $categories[$qData["category"]],
                "order" => $qData["id"],
            ]);

            $order = 1;
            foreach ($answersTemplate as $answerText => $score) {
                Answer::create([
                    "text" => $answerText,
                    "question_id" => $question->getKey(),
                    "score" => $score,
                    "order" => $order++,
                ]);
            }
        }
    }
}
