<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders;

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Concept7\LaravelQuestionnaire\Models\Answer;
use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Question;
use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Concept7\LaravelQuestionnaire\Models\Scale;
use File;

class DigitalMaturityScanSeederAction
{
    public function run($name)
    {
        $jsonPath =
            __DIR__ .
            "/../../../database/seeders/data/digital-maturity-scan.json";
        $data = json_decode(File::get($jsonPath), true);

        $questionnaire = Questionnaire::create([
            "title" => $name,
            "slug" => str($name)->slug()->toString(),
            "calculation_type" => CalculationTypeEnum::HIGHEST_SCORE,
        ]);

        $scales = [];
        foreach ($data["scales"] as $key => $scaleName) {
            $scales[$key] = Scale::create(["name" => $scaleName])->getKey();
        }

        $categories = [];
        foreach ($data["categories"] as $categoryName) {
            $categories[$categoryName] = Category::create([
                "name" => $categoryName,
            ])->getKey();
        }

        foreach ($categories as $categoryId) {
            for ($i = 1; $i <= 7; $i++) {
                Interpretation::create([
                    "category_id" => $categoryId,
                    "scale_id" => $scales[(string) $i],
                    "min_score" => $i,
                    "max_score" => $i,
                ]);
            }
        }

        foreach ($data["questions"] as $index => $qData) {
            $question = Question::create([
                "questionnaire_id" => $questionnaire->getKey(),
                "text" => $qData["question"],
                "category_id" => $categories[$qData["category"]],
                "type" => InputTypeEnum::CHECKBOX,
                "order" => $index + 1,
            ]);

            foreach ($qData["answers"] as $order => $answerData) {
                Answer::create([
                    "text" => $answerData["text"],
                    "question_id" => $question->getKey(),
                    "score" => $answerData["score"],
                    "order" => $order + 1,
                ]);
            }
        }
    }
}
