<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Concept7\LaravelQuestionnaire\Models\AssessmentAnswer;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use InvalidArgumentException;

class ProcessSubmittedAnswers
{
    public function handle(Collection $payload, Closure $next)
    {
        $questionnaire = $payload->get('questionnaire');
        $assessment = $payload->get('assessment');
        $validatedData = $payload->get('assessmentAnswers');

        if(empty($validatedData)) {
            throw new \Exception('No assessment answers found');
        }

        if(!$assessment || ! $questionnaire) {
            throw new InvalidArgumentException(
                'ProcessSubmittedAnswers action requires the "assessment" key and the "questionnaire" key in the payload.'
            );
        }

        $assessmentId = $assessment->getKey();
        $dbInsertData = [];
        $now = Carbon::now();

        foreach($validatedData as $questionId => $answerValue) {

            if(!str($questionId)->startsWith('questions_')) {
                continue;
            }

            if( is_array($answerValue) ) {
                foreach($answerValue as $answerId) {
                    $dbInsertData[] = [
                        'assessment_id' => $assessmentId,
                        'answer_id' => $answerId,
                        'created_at' => $now,
                        'updated_at' => $now,
                    ];
                }
            }else{
                $dbInsertData[] = [
                    'assessment_id' => $assessmentId,
                    'answer_id' => $answerValue,
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
            }
        }

        if(!empty($dbInsertData)){
            AssessmentAnswer::insert($dbInsertData);
        }

        $payload->put('submittedAnswers', collect($dbInsertData));

        return $next($payload);
    }
}
