<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Illuminate\Support\Collection;

class DetermineAndProcessResults
{
    public function handle(Collection $payload, Closure $next)
    {
        $assessment = $payload->get('assessment');

        if(!$assessment) {
            throw new \Exception('Assessment not found');
        }

        $assessmentResults = collect();

        foreach( $payload->get('scoresPerCategory') as $categoryId => $totalScore ) {
           $interpretation = Interpretation::query()
                ->where('category_id', $categoryId)
                ->where('min_score', '<=', $totalScore)
                ->where('max_score', '>=', $totalScore)
                ->first();

           if(!$interpretation){
                throw new \Exception("No interpretation found for category $categoryId with score $totalScore");
           }

           $result = $assessment->results()->create([
               'category_id' => $categoryId,
               'scale_id' => $interpretation->scale_id,
               'total_score' => $totalScore,
           ]);

           $assessmentResults->push($result);

        }


        $payload->put('assessmentResults', $assessmentResults);

        return $next($payload);
    }
}
