<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Concept7\LaravelQuestionnaire\Models\Assessment;
use Illuminate\Support\Collection;

class CreateAssessment
{
    public function handle(Collection $payload, Closure $next)
    {
        $user = $payload->get('user');
        $questionnaire = $payload->get('questionnaire');

        $assessmentClass = config('questionnaire.models.assessment', Assessment::class);

        if(! $user || ! $questionnaire) {
            throw new \Exception('User or Questionnaire not found');
        }

        $assessment = $assessmentClass::create([
            'user_id' => $user->getKey(),
            'questionnaire_id' => $questionnaire->getKey(),
            'completed_at' => now(),
        ]);

        $payload->put('assessment', $assessment);

        return $next($payload);
    }
}
