<?php

namespace Concept7\LaravelQuestionnaire\Database\Factories;

use Concept7\LaravelQuestionnaire\Models\Questionnaire;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Questionnaire>
 */
class QuestionnaireFactory extends Factory
{
    public function modelName(): mixed
    {
        return config("questionnaire.models.questionnaire");
    }

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            "title" => ($title = fake()->sentence()),
            "slug" => str($title)->slug()->toString(),
        ];
    }
}
