<?php

namespace Concept7\LaravelQuestionnaire\Database\Factories;

use Concept7\LaravelQuestionnaire\Models\Category;
use Concept7\LaravelQuestionnaire\Models\Interpretation;
use Concept7\LaravelQuestionnaire\Models\Scale;
use Illuminate\Database\Eloquent\Factories\Factory;

class InterpretationFactory extends Factory
{
    public function modelName(){
        return config('questionnaire.models.interpretation');
    }

    public function definition(): array
    {
        return [
            'min_score' => rand(1, 5),
            'max_score' => rand(5,20),
            'category_id' => Category::factory(),
            'scale_id'    => Scale::factory(),
        ];
    }
}
