<?php

namespace Concept7\LaravelQuestionnaire\Console\Commands;

use Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders\DasScanSeederAction;
use Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders\DigitalMaturityScanSeederAction;
use Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders\FourDklSeederAction;
use Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders\MinimalFakedSeederAction;
use Concept7\LaravelQuestionnaire\Actions\Assessments\Seeders\MvoScanSeederAction;
use Concept7\LaravelQuestionnaire\Models\User;
use Illuminate\Console\Command;

use function Laravel\Prompts\select;

class GenerateTestDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'questionnaire:generate-test-data-command';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate test data for the questionnaire';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        User::firstOrCreate(
            ['email' => 'jurn@concept7.nl'],
            [
                'name' => 'Test User',
                'password' => bcrypt('password'),
            ],
        );

        $name = select(
            label: 'What type of data would you like to use?',
            options: [
                '4DKL',
                'Concept7DigitalMaturityScan',
                'Minimal faked',
                'MVO Scan',
                'Das Scan',
            ],
            default: '4DKL',
        );

        $this->info("Generating $name questionnaire data...");

        match ($name) {
            '4DKL' => (new FourDklSeederAction)->run($name),
            'Concept7DigitalMaturityScan' => (new DigitalMaturityScanSeederAction)->run($name),
            'Minimal faked' => (new MinimalFakedSeederAction)->run($name),
            'MVO Scan' => (new MvoScanSeederAction)->run($name),
            'Das Scan' => (new DasScanSeederAction)->run($name),

            default => $this->error('Could not find seeder!')
        };

        $this->info(
            'Please visit the url: '.
                route('questionnaire.assessments.create', [
                    'questionnaire' => str($name)->slug()->toString(),
                ]),
        );
    }
}
