<?php

use Concept7\LaravelQuestionnaire\Enums\CalculationTypeEnum;
use Concept7\LaravelQuestionnaire\Enums\InputTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        Schema::create('questionnaires', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table
                ->string('calculation_type')
                ->default(CalculationTypeEnum::SUM);

            $table->timestamps();
        });

        Schema::create('questions', function (Blueprint $table) {
            $table->id();

            $table->text('text');
            $table->integer('order')->default(1);

            $table->string('type')->default(InputTypeEnum::RADIO);
            $table
                ->foreignId('category_id')
                ->constrained('categories')
                ->cascadeOnDelete();

            $table->integer('weight')->default(0);

            $table
                ->foreignId('questionnaire_id')
                ->constrained('questionnaires')
                ->cascadeOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('questions');
        Schema::dropIfExists('categories');
        Schema::dropIfExists('questionnaires');
    }
};
