<?php

use Concept7\LaravelQuestionnaire\Actions\Assessments\GetParticipant;
use Concept7\LaravelQuestionnaire\Models\User;

beforeEach(function () {
    config()->set('questionnaire.models.participant', User::class);
});

it('hydrates the participant model when participantId is present in payload', function () {
    $user = User::factory()->create();

    // 1. Simulate payload coming from the Controller (only has ID)
    $payload = collect([
        'participantId' => $user->id,
    ]);

    $action = new GetParticipant;

    // 2. Run the action
    $result = $action->handle($payload, fn ($p) => $p);

    // 3. Assert the Model is now in the payload
    expect($result->get('participant'))->toBeInstanceOf(User::class);
    expect($result->get('participant')->id)->toBe($user->id);
});

it('does nothing if participantId is missing (anonymous flow)', function () {
    $payload = collect([
        'participantId' => null,
    ]);

    $action = new GetParticipant;
    $result = $action->handle($payload, fn ($p) => $p);

    expect($result->has('participant'))->toBeFalse();
});
