<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class GetParticipant
{
    public function handle(Collection $payload, Closure $next)
    {
        $param = $payload->get('participantId');

        if (! $param) {
            return $next($payload);
        }

        if ($param instanceof Model) {
            $payload->put('participant', $param);

            return $next($payload);
        }

        $modelClass = config('questionnaire.models.participant');
        $urlKey = config('questionnaire.participant_url_key', 'id');

        $participant = $modelClass::where($urlKey, $param)->firstOrFail();

        $payload->put('participant', $participant);

        return $next($payload);
    }
}
