<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use InvalidArgumentException;

class ProcessSubmittedAnswers
{
    /**
     * @param  Collection<array-key,mixed>  $payload
     * @param  Closure(): void  $next
     * @return mixed
     */
    public function handle(Collection $payload, Closure $next)
    {
        $this->validatePayload($payload);

        $assessment = $payload->get('assessment');
        $validatedRequest = $payload->get('validatedRequest');

        $answersToInsert = collect($validatedRequest)
            ->flatMap(function ($value, $key) {
                $questionId = str($key)->after('questions_')->toString();

                if (empty($questionId)) {
                    return [];
                }

                $answerIds = (array) $value;

                return collect($answerIds)->map(fn ($answerId) => [
                    'answer_id' => $answerId,
                ]);
            })->all();

        DB::transaction(function () use ($assessment, $answersToInsert) {
            $assessment->answers()->createMany($answersToInsert);
        });

        $payload->put('submittedAnswers', $assessment->answers()->get());

        return $next($payload);
    }

    private function validatePayload(Collection $payload): void
    {
        if (! $payload->has('validatedRequest')) {
            throw new Exception('No assessment answers found in payload.');
        }

        if (! $payload->has('assessment')) {
            throw new InvalidArgumentException(
                'ProcessSubmittedAnswers action requires the "assessment" key.'
            );
        }
    }
}
