<?php

namespace Concept7\LaravelQuestionnaire\Actions\Assessments;

use Closure;
use Illuminate\Support\Collection;

class GetParticipant
{
    public function handle(Collection $payload, Closure $next)
    {
        $request = collect($payload->get('validatedRequest'));

        if (! $request->has('participant_id')) {
            // anonymous participant
            return $next($payload);
        }

        $modelClass = config('questionnaire.models.participant');
        $urlKey = config('questionnaire.participant_url_key', 'id');

        $participant = $modelClass::where($urlKey, $request->get('participant_id'))->firstOrFail();

        $payload->put('participant', $participant);

        return $next($payload);
    }
}
